<?php if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Get suffix for multilingual options pages.
 * 
 * @return string
 */
function pdg_get_option_suffix() {

	if ( defined( 'ICL_LANGUAGE_CODE' ) ) {
		$default_lang = apply_filters( 'wpml_default_language', NULL );

		if ( ICL_LANGUAGE_CODE != $default_lang ) {
			$id_suffix = '-' . ICL_LANGUAGE_CODE;
		} else {
			$id_suffix = '';
		}
	} else {
		$id_suffix = '';
	}

    return $id_suffix;

}

/**
 * Get messages from main contact form.
 * 
 * @since 2.0.0
 * 
 * @return boolean/array
 */
function pdg_get_cf_messages() {

    $id_suffix = pdg_get_option_suffix();
    $form = false;

    if ( get_field( 'pdg_general_main_cf', 'option' . $id_suffix ) ) {
        $form = get_field( 'pdg_general_main_cf', 'option' . $id_suffix );
    }

    if ( $form ) {
        return WPCF7_ContactForm::get_instance( $form->ID )->get_properties()['messages'];
    }

    return false;

}