<?php if ( ! defined( 'ABSPATH' ) ) exit; ?>

<!doctype html>
<html>
    <head>
        <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/main.css">
		<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/vendor/pandago/developer.css">
	</head>
	<body>

        <div class="pdg-dev">
            <div class="pdg-dev__inner">
                <div class="pdg-dev__container">
                    <h1>Generate block files</h1>

                    <div class="pdg-dev__editor before-form">
                        <p>This will generate sample files for a new block in the child theme folder /blocks/my-block where "my-block" is generated from block name entered below.</p>
                        <p>You'll still need to add block to blocks.php file manually.</p>
                        <h3>Naming</h3>
                        <p>Enter block name as you would in blocks.php file. e.g. My Block. Folder name will be generated replacing all spaces with dashes. Class name will be generated replacing all spaces with underscores.</p>
                        <h3>Files</h3>
                        <p>The following files will be generated:</p>
                        <ul>
                            <li>index.php</li>
                            <li>controller.php</li>
                            <li>template.php</li>
                            <li>style.css (optional)</li>
                            <li>script.js (optional)</li>
                        </ul>
                    </div>

                    <form class="pdg-dev-form" action="" method="post">
                        <?php wp_nonce_field( 'pdg_generate_block', 'pdg_block_nonce' ); ?>

                        <div class="pdg-dev__inline-inputs">
                            <div class="pdg-dev__inline-input pdg-dev__inline-input--block-name">
                                <input name="block_name" type="text" required placeholder="Block name: e.g. My Block">
                            </div>

                            <div class="pdg-dev__inline-input pdg-dev__inline-input--block-cb">
                                <label class="pdg-dev-cb">
                                    <input name="block_css" type="checkbox" checked>

                                    <span class="pdg-dev-cb__label">Generate style.css</span>
                                </label>
                            </div>

                            <div class="pdg-dev__inline-input pdg-dev__inline-input--block-cb">
                                <label class="pdg-dev-cb">
                                    <input name="block_js" type="checkbox">

                                    <span class="pdg-dev-cb__label">Generate script.js</span>
                                </label>
                            </div>

                            <div class="pdg-dev__inline-input pdg-dev__inline-input--block-cb">
                                <label class="pdg-dev-cb">
                                    <input name="block_ajax" type="checkbox">

                                    <span class="pdg-dev-cb__label">Generate ajax.php</span>
                                </label>
                            </div>

                            <div class="pdg-dev__inline-input pdg-dev__inline-input--block-btn">
                                <input class="pdg-dev-btn pdg-dev-btn--primary pdg-dev-btn--full" type="submit" value="Generate">
                            </div>
                        </div>
                    </form>

                    <?php
                    if ( $_POST && isset( $_POST['block_name'] ) && $_POST['block_name'] && is_user_logged_in() && current_user_can( 'administrator' ) ) {

                        if ( ! isset( $_POST['pdg_block_nonce'] ) || ! wp_verify_nonce( $_POST['pdg_block_nonce'], 'pdg_generate_block' ) ) {
                            echo '<p style="color: red;">Security check failed.</p>';
                            return;
                        }

                        $folder = strtolower( $_POST['block_name'] );
                        $folder = sanitize_file_name( str_replace( ' ', '-', $folder ) );
                        $class  = sanitize_text_field( str_replace( ' ', '_', $_POST['block_name'] ) );

                        // Validate folder name doesn't contain path traversal
                        if ( strpos( $folder, '..' ) !== false || strpos( $folder, '/' ) !== false ) {
                            echo '<p style="color: red;">Invalid block name.</p>';
                            return;
                        }

                        // Create 'blocks' folder.
                        if ( ! file_exists( PDGC_PATH . '/blocks' ) ) {
                            mkdir( PDGC_PATH . '/blocks', 0777, true );
                        }

                        // Check if folder already exists.
                        if ( file_exists( PDGC_PATH . '/blocks/' . $folder ) ) {
                            echo '<p style="color: red;">Folder already exists.</p>';
                            exit;
                        }

                        // Create current block folder.
                        if ( ! file_exists( PDGC_PATH . '/blocks/' . $folder ) ) {
                            mkdir( PDGC_PATH . '/blocks/' . $folder, 0777, true );
                        }

                        // index.php
                        $index = fopen( PDGC_PATH . '/blocks/' . $folder . '/index.php', 'w' );
                
                        $index_contents  = "<?php if ( ! defined( 'ABSPATH' ) ) exit;\n\n";
                        $index_contents .= "include_once PDGC_INC . '/class-blocks-extender.php';\n";
                        $index_contents .= "include_once dirname( __FILE__ ) . '/controller.php';\n\n";
                        $index_contents .= 'new PDGC_Block_' . $class . '( $block, $post_id );';
                
                        fwrite( $index, $index_contents );
                        fclose( $index );
                
                        // controller.php
                        $controller = fopen( PDGC_PATH . '/blocks/' . $folder . '/controller.php', 'w' );
                
                        $controller_contents  = "<?php if ( ! defined( 'ABSPATH' ) ) exit;\n\n";
                        $controller_contents .= "class PDGC_Block_" . $class . " extends PDGC_Block_Extender\n";
                        $controller_contents .= "{\n\n";
                        $controller_contents .= "\t" . 'public function __construct( $block, $post_id ) {' . "\n\n";
                        $controller_contents .= "\t\t" . 'parent::__construct( $block, $post_id );' . "\n\n";
                        $controller_contents .= "\t\t" . '$this->set_args();' . "\n\n";
                        $controller_contents .= "\t\t" . '$this->render();' . "\n\n";
                        $controller_contents .= "\t}\n\n";
                        $controller_contents .= "\tprivate function set_args() {\n\n";
                        $controller_contents .= "\t\t" . '$this->args = [' . "\n";
                        $controller_contents .= "\t\t\t" . '\'id\' => $this->block[\'id\'],' . "\n"; 
                        $controller_contents .= "\t\t" . '];' . "\n\n";
                        $controller_contents .= "\t}\n\n";
                        $controller_contents .= "}";

                        fwrite( $controller, $controller_contents );
                        fclose( $controller );
                
                        // template.php
                        $template = fopen( PDGC_PATH . '/blocks/' . $folder . '/template.php', 'w' );

                        $template_contents  = "<?php if ( ! defined( 'ABSPATH' ) ) exit; ?>\n\n";
                        $template_contents .= '<section class="b-YOUR_BLOCK_CLASS <?php echo $args[\'instance\']->the_block_class(); ?>" <?php $args[\'instance\']->the_block_anchor(); ?>>' . "\n";
                        $template_contents .= "\t" . '<?php $args[\'instance\']->the_block_container(); ?>' . "\n";
                        $template_contents .= "\t" . '<?php $args[\'instance\']->the_block_container( \'end\' ); ?>' . "\n";
                        $template_contents .= "</section>\n";
                
                        fwrite( $template, $template_contents );
                        fclose( $template );
                
                        // style.css
                        if ( isset( $_POST['block_css'] ) ) {
                            $style = fopen( PDGC_PATH . '/blocks/' . $folder . '/style.css', 'w' );
                
                            fwrite( $style, '' );
                            fclose( $style );
                        }

                        // script.js
                        if ( isset( $_POST['block_js'] ) ) {
                            $script = fopen( PDGC_PATH . '/blocks/' . $folder . '/script.js', 'w' );

                            $script_contents = "( $ => {\n\n";
                            $script_contents .= "\t" . 'const Script = {' . "\n";
                            $script_contents .= "\t\t" . 'init: () => {' . "\n\n";
                            $script_contents .= "\t\t\t" . 'Script.listeners();' . "\n\n";
                            $script_contents .= "\t\t" . '},' . "\n\n";
                            $script_contents .= "\t\t" . 'listeners: () => {' . "\n\n";
                            $script_contents .= "\t\t" . '}' . "\n";
                            $script_contents .= "\t" . '};' . "\n\n";
                            $script_contents .= "\t" . '$( document ).ready( Script.init );' . "\n\n";
                            $script_contents .= '} ) ( jQuery );';

                            fwrite( $script, $script_contents );
                            fclose( $script );
                        }

                        // ajax.php
                        if ( isset( $_POST['block_ajax'] ) ) {
                            $ajax = fopen( PDGC_PATH . '/blocks/' . $folder . '/ajax.php', 'w' );

                            $ajax_contents = "<?php if ( ! defined( 'ABSPATH' ) ) exit;\n\n";
                            $ajax_contents .= "function YOUR_BLOCK_AJAX_FUNCTION() {\n\n";
                            $ajax_contents .= "\t" . '// Your code here' . "\n\n";
                            $ajax_contents .= '}' . "\n";
                            $ajax_contents .= "add_action( 'wp_ajax_YOUR_BLOCK_AJAX_FUNCTION', 'YOUR_BLOCK_AJAX_FUNCTION' );\n";
                            $ajax_contents .= "add_action( 'wp_ajax_nopriv_YOUR_BLOCK_AJAX_FUNCTION', 'YOUR_BLOCK_AJAX_FUNCTION' );";

                            fwrite( $ajax, $ajax_contents );
                            fclose( $ajax );
                        }

                        delete_transient( 'pdg_allowed_blocks' );

                        echo '<p style="color: green;">Block files generated.</p>';
                    }
                    ?>
                </div>
            </div>
        </div>

        <?php wp_footer(); ?>
    </body>
</html>