<?php if ( ! defined( 'ABSPATH' ) ) exit; ?>

<?php if ( $items = PDG::get_global_option( 'social' ) ): ?>
    <ul class="<?php if ( isset( $args['class'] ) ): ?><?php echo $args['class']; ?><?php endif; ?> social-nav flex align-items-center">
        <?php foreach ( $items as $item ): ?>
            <li class="social-nav__item is-<?php echo sanitize_title( $item['title'] ); ?>">
                <?php if ( $item['icon_type'] == 'image' && $item['icon_img'] ): ?>
                    <a class="social-nav__link d-block" href="<?php echo esc_url( $item['url'] ); ?>" target="_blank" aria-label="<?php echo esc_attr( $item['title'] ); ?>">
                        <?php PDG::img( $item['icon_img'], 'full', [
                            'title' => false,
                            'class' => ['d-block']
                        ] ); ?>
                    </a>
                <?php elseif ( $item['icon_type'] == 'html' && $item['html'] ): ?>
                    <a class="social-nav__link d-block" href="<?php echo esc_url( $item['url'] ); ?>" target="_blank" aria-label="<?php echo esc_attr( $item['title'] ); ?>">
                        <?php echo $item['html']; ?>
                    </a>
                <?php else: ?>
                    <a class="social-nav__link ic ic--<?php echo $item['icon']; ?> d-block" href="<?php echo esc_url( $item['url'] ); ?>" target="_blank" aria-label="<?php echo esc_attr( $item['title'] ); ?>"></a>
                <?php endif; ?>
            </li>
        <?php endforeach; ?>
    </ul>
<?php endif; ?>