<?php if ( ! defined( 'ABSPATH' ) ) exit; ?>

<?php if ( $args && $args['title'] && $args['url'] ): ?>
    <?php if ( isset( $args['wrap'] ) && $args['wrap'] ): ?>
        <div class="<?php echo $args['wrap']; ?>">
    <?php endif; ?>

    <a class="<?php echo ( isset( $args['class'] ) ) ? $args['class'] : ''; ?> btn btn--<?php echo ( isset( $args['style'] ) ) ? $args['style'] : 'primary'; ?>" href="<?php echo esc_url( $args['url'] ); ?>" <?php if ( isset( $args['target'] ) && $args['target'] ): ?>target="<?php echo $args['target']; ?>"<?php endif; ?>>
        <?php if ( isset( $args['svg_icon_before'] ) ): ?>
            <?php if ( is_array( $args['svg_icon_before'] ) ): ?>
                <?php PDG::icon( $args['svg_icon_before'][0], true, $args['svg_icon_before'][1] ); ?>
            <?php else: ?>
                <?php get_template_part( $args['svg_icon_before'] ); ?>
            <?php endif; ?>
        <?php endif; ?>

        <?php echo $args['title']; ?>

        <?php if ( isset( $args['svg_icon_after'] ) ): ?>
            <?php if ( is_array( $args['svg_icon_after'] ) ): ?>
                <?php PDG::icon( $args['svg_icon_after'][0], true, $args['svg_icon_after'][1] ); ?>
            <?php else: ?>
                <?php get_template_part( $args['svg_icon_after'] ); ?>
            <?php endif; ?>
        <?php endif; ?>
    </a>

    <?php if ( isset( $args['wrap'] ) && $args['wrap'] ): ?>
        </div>
    <?php endif; ?>
<?php endif; ?>