<?php if ( ! defined( 'ABSPATH' ) ) exit;

if ( ! $args || ! array_key_exists( 'image', $args ) ) return;

$sizes = [
    'lg' => $args['sizes']['lg'] ?? 'large',
    'md' => $args['sizes']['md'] ?? 'medium',
    'sm' => $args['sizes']['sm'] ?? 'medium',
];

// Get alt text
$alt = '';
if ( is_array( $args['image'] ) && isset( $args['image']['alt'] ) ) {
    $alt = $args['image']['alt'];
} elseif ( ! is_array( $args['image'] ) ) {
    $alt = get_post_meta( $args['image'], '_wp_attachment_image_alt', true );
}

// Get image sources with fallbacks
$image_lg = PDG::get_image_src( $args['image'], $sizes['lg'] );
$image_md = PDG::get_image_src( $args['image_md'] ?? $args['image'], $sizes['md'] );
$image_sm = PDG::get_image_src( $args['image_sm'] ?? $args['image'], $sizes['sm'] );

$class = isset( $args['class'] ) ? " {$args['class']}" : '';
?>

<picture class="background-picture<?php echo $class; ?>">
    <source media="(max-width: 767px)" srcset="<?php echo $image_sm; ?>">
    <source media="(max-width: 1099px)" srcset="<?php echo $image_md; ?>">
    <img class="background-picture__image" src="<?php echo $image_lg; ?>" alt="<?php echo esc_attr( $alt ); ?>">
</picture>