<?php if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Handle theme updates.
 */
function pdg_check_for_theme_update( $transient ) {

    if ( empty( $transient->checked ) ) {
        return $transient;
    }

    $theme_slug = 'pandago3';
    $theme_data = wp_get_theme( $theme_slug );

    $update_url = PDG_UPDATE_URL;

    $response = wp_remote_get( $update_url );

    if ( ! is_wp_error( $response ) && isset( $response['response']['code'] ) && $response['response']['code'] === 200 ) {
        $update_data = json_decode( wp_remote_retrieve_body( $response ), true );

        if ( $update_data && isset( $update_data['new_version'] ) && version_compare( $theme_data->get( 'Version' ), $update_data['new_version'], '<' ) ) {
            $transient->response[$theme_slug] = [
                'theme'        => $theme_slug,
                'new_version'  => $update_data['new_version'],
                'url'          => $update_data['url'],
                'package'      => $update_data['package'],
                'requires'     => $update_data['requires'],
                'requires_php' => $update_data['requires_php'],
                'sections'     => $update_data['sections']
            ];
        }
    }

    return $transient;

}
add_filter('pre_set_site_transient_update_themes', 'pdg_check_for_theme_update');
add_filter('site_transient_update_themes', 'pdg_check_for_theme_update');