<?php if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Generates instructions for "JavaScript Plugins" options
 * page fields for code readibility.
 */
function pdg_js_options_instructions( $handle, $link, $ver, $js, $css ) {

	$has_js  = ( $js ) ? 'Yes' : 'No';
	$has_css = ( $css ) ? 'Yes' : 'No';

	$handle = '<strong>Handle:</strong> ' . $handle . '<br>';
	$link   = '<strong>Link:</strong> <a href="' . $link . '" target="_blank">here</a><br>';
	$ver    = '<strong>Version:</strong> ' . $ver . '<br>';
    $assets = '';

    if ( $js && $css ) {
        $assets = '<strong>Assets:</strong> JS and CSS';
    } elseif ( $js && ! $css ) {
        $assets = '<strong>Assets:</strong> JS only';
    }

	return $handle . $link . $ver . $assets;

}

/**
 * Add fields for "JavaScript Plugins" options page.
 */
acf_add_local_field_group( array(
	'key'   => 'group_pdg_js',
	'title' => 'JavaScript Plugins',

	'fields' => array(
		array(
			'key' => 'pdg_js_info',
			'label' => 'Info',
			'name' => '',
			'type'              => 'message',
			'instructions'      => '',
			'required'          => 0,
			'conditional_logic' => 0,
			'wrapper'           => array(
				'width' => '',
				'class' => '',
				'id'    => ''
			),
			'message'           => 'Ticking "Register" will register the plugin files using wp_register_* function which you can later on enqueue using wp_enqueue_* when you need it.<br>If plugin has only JS you need to use just wp_enqueue_script() if it has both JS and CSS you additionally need to use wp_enqueue_style().<br><br>Ticking "Enqueue" will enqueue plugin files on all pages.',
			'new_lines'         => 'wpautop',
			'esc_html'          => 0
		),
		array(
			'key' => 'pdg_js_aos',
			'label' => 'AOS',
			'name' => 'pdg_js_aos',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => pdg_js_options_instructions( 'pdg-aos', 'https://github.com/michalsnik/aos/tree/v2/', '2.0.0', true, true ),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '33.33',
				'class' => '',
				'id' => '',
			),
			'wpml_cf_preferences' => 1,
			'choices' => array(
				'disable' => 'Disable',
				'register' => 'Register',
				'enqueue' => 'Enqueue',
			),
			'default_value' => 'disable',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'horizontal',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'pdg_js_datepicker',
			'label' => 'Datepicker',
			'name' => 'pdg_js_datepicker',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => pdg_js_options_instructions( 'pdg-datepicker', 'https://api.jqueryui.com/datepicker/', '1.12.1', true, true ),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '33.33',
				'class' => '',
				'id' => '',
			),
			'wpml_cf_preferences' => 1,
			'choices' => array(
				'disable' => 'Disable',
				'register' => 'Register',
				'enqueue' => 'Enqueue',
			),
			'default_value' => 'disable',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'horizontal',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'pdg_js_fancybox',
			'label' => 'Fancybox',
			'name' => 'pdg_js_fancybox',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => pdg_js_options_instructions( 'pdg-fancybox', 'http://fancyapps.com/fancybox/3/', '3.5.7', true, true ),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '33.33',
				'class' => '',
				'id' => '',
			),
			'wpml_cf_preferences' => 1,
			'choices' => array(
				'disable' => 'Disable',
				'register' => 'Register',
				'enqueue' => 'Enqueue',
			),
			'default_value' => 'disable',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'horizontal',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'pdg_js_flexslider',
			'label' => 'Flexslider',
			'name' => 'pdg_js_flexslider',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => pdg_js_options_instructions( 'pdg-flexslider', 'http://flexslider.woothemes.com/', '2.7.2', true, true ),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '33.33',
				'class' => '',
				'id' => '',
			),
			'wpml_cf_preferences' => 1,
			'choices' => array(
				'disable' => 'Disable',
				'register' => 'Register',
				'enqueue' => 'Enqueue',
			),
			'default_value' => 'disable',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'horizontal',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'pdg_js_google_maps',
			'label' => 'Google Maps (API key at the bottom)',
			'name' => 'pdg_js_google_maps',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => pdg_js_options_instructions( 'pdg-google_maps', 'https://developers.google.com/maps/documentation/javascript/overview', '3', true, false ),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '33.33',
				'class' => '',
				'id' => '',
			),
			'wpml_cf_preferences' => 1,
			'choices' => array(
				'disable' => 'Disable',
				'register' => 'Register',
				'enqueue' => 'Enqueue',
			),
			'default_value' => 'disable',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'horizontal',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'pdg_js_hoverintent',
			'label' => 'HoverIntent',
			'name' => 'pdg_js_hoverintent',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => pdg_js_options_instructions( 'pdg-hoverintent', 'https://github.com/briancherne/jquery-hoverIntent', '1.10.1', true, false ),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '33.33',
				'class' => '',
				'id' => '',
			),
			'wpml_cf_preferences' => 1,
			'choices' => array(
				'disable' => 'Disable',
				'register' => 'Register',
				'enqueue' => 'Enqueue',
			),
			'default_value' => 'disable',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'horizontal',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'pdg_js_isonscreen',
			'label' => 'isOnScreen',
			'name' => 'pdg_js_isonscreen',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => pdg_js_options_instructions( 'pdg-isonscreen', 'https://github.com/moagrius/isOnScreen/', 'N/A', true, false ),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '33.33',
				'class' => '',
				'id' => '',
			),
			'wpml_cf_preferences' => 1,
			'choices' => array(
				'disable' => 'Disable',
				'register' => 'Register',
				'enqueue' => 'Enqueue',
			),
			'default_value' => 'disable',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'horizontal',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'pdg_js_leaflet',
			'label' => 'Leaflet',
			'name' => 'pdg_js_leaflet',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => pdg_js_options_instructions( 'pdg-leaflet', 'https://leafletjs.com/', '1.9.4', true, true ),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '33.33',
				'class' => '',
				'id' => '',
			),
			'wpml_cf_preferences' => 1,
			'choices' => array(
				'disable' => 'Disable',
				'register' => 'Register',
				'enqueue' => 'Enqueue',
			),
			'default_value' => 'disable',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'horizontal',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'pdg_js_matchheight',
			'label' => 'MatchHeight',
			'name' => 'pdg_js_matchheight',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => pdg_js_options_instructions( 'pdg-matchheight', 'https://github.com/liabru/jquery-match-height', '0.7.2', true, false ),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '33.33',
				'class' => '',
				'id' => '',
			),
			'wpml_cf_preferences' => 1,
			'choices' => array(
				'disable' => 'Disable',
				'register' => 'Register',
				'enqueue' => 'Enqueue',
			),
			'default_value' => 'disable',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'horizontal',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'pdg_js_nicescroll',
			'label' => 'NiceScroll',
			'name' => 'pdg_js_nicescroll',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => pdg_js_options_instructions( 'pdg-nicescroll', 'https://nicescroll.areaaperta.com/', '3.7.6', true, false ),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '33.33',
				'class' => '',
				'id' => '',
			),
			'wpml_cf_preferences' => 1,
			'choices' => array(
				'disable' => 'Disable',
				'register' => 'Register',
				'enqueue' => 'Enqueue',
			),
			'default_value' => 'disable',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'horizontal',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'pdg_js_slick',
			'label' => 'Slick Slider',
			'name' => 'pdg_js_slick',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => pdg_js_options_instructions( 'pdg-slick', 'https://kenwheeler.github.io/slick/', '1.8.1', true, true ),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '33.33',
				'class' => '',
				'id' => '',
			),
			'wpml_cf_preferences' => 1,
			'choices' => array(
				'disable' => 'Disable',
				'register' => 'Register',
				'enqueue' => 'Enqueue',
			),
			'default_value' => 'disable',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'horizontal',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'pdg_js_sumoselect',
			'label' => 'SumoSelect',
			'name' => 'pdg_js_sumoselect',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => pdg_js_options_instructions( 'pdg-sumoselect', 'https://github.com/HemantNegi/jquery.sumoselect', '3.0.2', true, true ),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '33.33',
				'class' => '',
				'id' => '',
			),
			'wpml_cf_preferences' => 1,
			'choices' => array(
				'disable' => 'Disable',
				'register' => 'Register',
				'enqueue' => 'Enqueue',
			),
			'default_value' => 'disable',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'horizontal',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'pdg_js_tooltipster',
			'label' => 'Tooltipster',
			'name' => 'pdg_js_tooltipster',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => pdg_js_options_instructions( 'pdg-tooltipster', 'https://www.heteroclito.fr/modules/tooltipster/', '4.2.8', true, true ),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '33.33',
				'class' => '',
				'id' => '',
			),
			'wpml_cf_preferences' => 1,
			'choices' => array(
				'disable' => 'Disable',
				'register' => 'Register',
				'enqueue' => 'Enqueue',
			),
			'default_value' => 'disable',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'horizontal',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'pdg_js_validation',
			'label' => 'Validation',
			'name' => 'pdg_js_validation',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => pdg_js_options_instructions( 'pdg-validation', 'https://jqueryvalidation.org/', '1.19.5', true, false ),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '33.33',
				'class' => '',
				'id' => '',
			),
			'wpml_cf_preferences' => 1,
			'choices' => array(
				'disable' => 'Disable',
				'register' => 'Register',
				'enqueue' => 'Enqueue',
			),
			'default_value' => 'disable',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'horizontal',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'pdg_js_videojs',
			'label' => 'VideoJS',
			'name' => 'pdg_js_videojs',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => pdg_js_options_instructions( 'pdg-videojs', 'https://videojs.com/getting-started', '8.9.0', true, true ),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '33.33',
				'class' => '',
				'id' => '',
			),
			'wpml_cf_preferences' => 1,
			'choices' => array(
				'disable' => 'Disable',
				'register' => 'Register',
				'enqueue' => 'Enqueue',
			),
			'default_value' => 'disable',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'horizontal',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'pdg_gm_key',
			'label' => 'Google Maps API Key',
			'name' => 'pdg_gm_key',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '70',
				'class' => '',
				'id' => '',
			),
			'wpml_cf_preferences' => 1,
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'pdg_gm_callback',
			'label' => 'Google Maps Callback Function',
			'name' => 'pdg_gm_callback',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '30',
				'class' => '',
				'id' => '',
			),
			'wpml_cf_preferences' => 1,
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
	),

	'location' => array(
		array(
			array(
				'param' => 'options_page',
				'operator' => '==',
				'value' => 'pdg-js',
			),
		),
	),

	'menu_order'            => 0,
	'position'              => 'normal',
	'style'                 => 'default',
	'label_placement'       => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen'        => '',
	'active'                => true,
	'description'           => ''
) );