<?php if ( ! defined( 'ABSPATH' ) ) exit;

$fields = [];

if ( $has_wpml ) {
    $fields[] = array(
        'key' => 'pdg_general_hide_langswitch',
        'label' => 'Hide Language Switcher',
        'name' => 'pdg_general_hide_langswitch',
        'aria-label' => '',
        'type' => 'radio',
        'instructions' => '',
        'required' => 0,
        'conditional_logic' => 0,
        'wrapper' => array(
            'width' => '',
            'class' => '',
            'id' => '',
        ),
        'wpml_cf_preferences' => 1,
        'choices' => array(
            'no' => 'No',
            'yes' => 'Yes (for everyone)',
            'logged' => 'Yes (for non logged in users)',
        ),
        'default_value' => 'no',
        'return_format' => 'value',
        'allow_null' => 0,
        'other_choice' => 0,
        'layout' => 'horizontal',
        'save_other_choice' => 0,
    );
}

if ( $has_wpcf7 ) {
    $fields[] = array(
        'wpml_cf_preferences' => 0,

        'key'               => 'pdg_general_main_cf',
        'label'             => 'Main Contact Form',
        'name'              => 'pdg_general_main_cf',
        'type'              => 'post_object',
        'instructions'      => 'Main Contact form from which messages will be retrieved for validation.',
        'required'          => 0,
        'conditional_logic' => 0,
        'wrapper'           => array(
            'width' => '',
            'class' => '',
            'id'    => ''
        ),
        'post_type'         => array(
            0 => 'wpcf7_contact_form',
        ),
        'taxonomy'          => '',
        'allow_null'        => 1,
        'multiple'          => 0,
        'return_format'     => 'object',
        'ui'                => 1
    );

    $fields[] = array(
        'key'                 => 'pdg_general_debug_cf7',
        'label'               => 'Debug Contact Form 7',
        'name'                => 'pdg_general_debug_cf7',
        'type'                => 'true_false',
        'instructions'        => 'If enabled, all form submissions from given IP address will be sent to given email instead of form recipients email.',
        'required'            => 0,
        'conditional_logic'   => 0,
        'wrapper'             => array(
            'width' => '',
            'class' => '',
            'id'    => '',
        ),
        'message'             => '',
        'default_value'       => 0,
        'ui'                  => 0,
        'wpml_cf_preferences' => 1,
        'ui_on_text'          => '',
        'ui_off_text'         => ''
    );

    $ip_address = isset( $_SERVER['REMOTE_ADDR'] ) ? $_SERVER['REMOTE_ADDR'] : 'IP not available';

    $fields[] = array(
        'key'                => 'pdg_general_debug_cf7_ip',
        'label'              => 'IP address',
        'name'               => 'pdg_general_debug_cf7_ip',
        'type'               => 'text',
        'instructions'       => 'Your IP address is: ' . $ip_address,
        'required'           => 0,
        'conditional_logic'  => array(
            array(
                array(
                    'field'    => 'pdg_general_debug_cf7',
                    'operator' => '==',
                    'value'    => '1',
                ),
            ),
        ),
        'wrapper'             => array(
            'width' => '',
            'class' => '',
            'id'    => '',
        ),
        'wpml_cf_preferences' => 1,
        'default_value'       => '',
        'placeholder'         => '',
        'prepend'             => '',
        'append'              => '',
        'maxlength'           => ''
    );

    $fields[] = array(
        'key'                 => 'pdg_general_debug_cf7_email',
        'label'               => 'Email',
        'name'                => 'pdg_general_debug_cf7_email',
        'type'                => 'text',
        'instructions'        => '',
        'required'            => 0,
        'conditional_logic'   => array(
            array(
                array(
                    'field'    => 'pdg_general_debug_cf7',
                    'operator' => '==',
                    'value'    => '1',
                ),
            ),
        ),
        'wrapper'             => array(
            'width' => '',
            'class' => '',
            'id'    => '',
        ),
        'wpml_cf_preferences' => 1,
        'default_value'       => '',
        'placeholder'         => '',
        'prepend'             => '',
        'append'              => '',
        'maxlength'           => ''
    );
}

acf_add_local_field_group( array(
    'key'   => 'group_pdg_general',
    'title' => 'General',

    'fields' => $fields,

    'location' => array(
        array(
            array(
                'param'    => 'options_page',
                'operator' => '==',
                'value'    => 'pdg-general',
            )
        )
    ),

    'menu_order'            => 0,
    'position'              => 'normal',
    'style'                 => 'default',
    'label_placement'       => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen'        => '',
    'active'                => true,
    'description'           => ''
) );