<?php if ( ! defined( 'ABSPATH' ) ) exit;

add_action( 'acf/init', function() {
    global $has_yoast;
    $fields = [];

    if ( $has_yoast ) {
        // Get post types.
        $post_types = get_post_types( [
            'public'   => true,
            '_builtin' => false
        ], 'objects' );

        // Get default post type.
        $default_post_type = get_post_type_object( 'post' );

        if ( $post_types ) {
            $post_types = array_merge( [ 'post' => $default_post_type ], $post_types );
        } else {
            $post_types = [ 'post' => $default_post_type ];
        }

        if ( $post_types ) {
            $fields[] = [
                'key' => 'pdgc_breadcrumbs_post_tab',
                'label' => 'Post Types',
                'name' => '',
                'aria-label' => '',
                'type' => 'tab',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'wpml_cf_preferences' => 0,
                'placement' => 'top',
                'endpoint' => 0,
                'selected' => 0,
            ];

            foreach ( $post_types as $post_type ) {
                if ( strpos( $post_type->name, 'acf-' ) === 0 ) {
                    continue;
                }

                $fields[] = [
                    'key' => 'pdgc_breadcrumbs_post_' . $post_type->name,
                    'label' => $post_type->label . ' (' . $post_type->name . ')',
                    'name' => 'pdgc_breadcrumbs_post_' . $post_type->name,
                    'aria-label' => '',
                    'type' => 'post_object',
                    'instructions' => 'Select root page for ' . $post_type->label . ' post type.',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'wpml_cf_preferences' => 2,
                    'post_type' => array(
                        0 => 'page',
                    ),
                    'post_status' => '',
                    'taxonomy' => '',
                    'return_format' => 'object',
                    'multiple' => 0,
                    'allow_null' => 1,
                    'bidirectional' => 0,
                    'ui' => 1,
                    'bidirectional_target' => array(),
                ];
            }
        }

        // Get taxonomies.
        $taxonomies = get_taxonomies( [
            'public' => true,
        ], 'objects' );

        if ( $taxonomies ) {
            if ( isset( $taxonomies['post_tag'] ) ) {
                unset( $taxonomies['post_tag'] );
            }

            if ( isset( $taxonomies['post_format'] ) ) {
                unset( $taxonomies['post_format'] );
            }

            $fields[] = [
                'key' => 'pdgc_breadcrumbs_taxonomy_tab',
                'label' => 'Taxonomies',
                'name' => '',
                'aria-label' => '',
                'type' => 'tab',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'wpml_cf_preferences' => 0,
                'placement' => 'top',
                'endpoint' => 0,
                'selected' => 0,
            ];

            foreach ( $taxonomies as $taxonomy ) {
                if ( strpos( $taxonomy->name, 'acf-' ) === 0 ) {
                    continue;
                }

                $fields[] = [
                    'key' => 'pdgc_breadcrumbs_tax_' . $taxonomy->name,
                    'label' => $taxonomy->label . ' (' . $taxonomy->name . ')',
                    'name' => 'pdgc_breadcrumbs_tax_' . $taxonomy->name,
                    'aria-label' => '',
                    'type' => 'post_object',
                    'instructions' => 'Select root page for ' . $taxonomy->label . ' taxonomy.',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'wpml_cf_preferences' => 2,
                    'post_type' => array(
                        0 => 'page',
                    ),
                    'post_status' => '',
                    'taxonomy' => '',
                    'return_format' => 'object',
                    'multiple' => 0,
                    'allow_null' => 1,
                    'bidirectional' => 0,
                    'ui' => 1,
                    'bidirectional_target' => array(),
                ];
            }
        }
    }
    
    acf_add_local_field_group( array(
        'key'   => 'group_pdgc_breadcrumbs',
        'title' => 'Breadcrumbs',
    
        'fields' => $fields,
    
        'location' => array(
            array(
                array(
                    'param'    => 'options_page',
                    'operator' => '==',
                    'value'    => 'pdg-breadcrumbs',
                )
            )
        ),
    
        'menu_order'            => 0,
        'position'              => 'normal',
        'style'                 => 'default',
        'label_placement'       => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen'        => '',
        'active'                => true,
        'description'           => ''
    ) );
}, 200 );