<?php if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Disable access to anyone but admins.
 */
if ( is_admin() && ! current_user_can( 'administrator' ) ) {
	return;
}

if ( ! function_exists( 'is_plugin_active' ) ) {
    require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
}

$has_wpml  = defined( 'ICL_LANGUAGE_CODE' );
$has_wpcf7 = class_exists( 'WPCF7' );
$has_yoast = is_plugin_active( 'wordpress-seo/wp-seo.php' );

/**
 * Add custom options pages.
 */
add_action( 'acf/init', function() {

    global $has_wpml, $has_wpcf7, $has_yoast;

    // Theme options.
	acf_add_options_page( [
        'page_title' => 'Theme Options',
        'menu_title' => 'Theme Options',
		'menu_slug'  => 'pdgc-options',
        'position'   => '998.9'
    ] );

	acf_add_options_sub_page( [
        'page_title'  => 'General',
        'menu_title'  => 'General',
		'menu_slug'   => 'pdgc-general',
        'parent_slug' => 'pdgc-options',
		'position'    => '10'
    ] );

	acf_add_options_sub_page( [
        'page_title'  => 'Social Networks',
        'menu_title'  => 'Social Networks',
		'menu_slug'   => 'pdgc-soc',
        'parent_slug' => 'pdgc-options',
		'position'    => '10.1'
    ] );

    // PandaGo Options
    acf_add_options_page( [
        'page_title' => 'PandaGo Options',
        'menu_title' => 'PandaGo Options',
        'menu_slug'  => 'pdg-options',
        'position'   => '999.9'
    ] );

    if ( $has_wpml || $has_wpcf7 ) {
        acf_add_options_sub_page( [
            'page_title'  => 'General',
            'menu_title'  => 'General',
            'menu_slug'   => 'pdg-general',
            'parent_slug' => 'pdg-options'
        ] );
    }

    acf_add_options_sub_page( [
        'page_title'  => 'JavaScript Plugins',
        'menu_title'  => 'JavaScript Plugins',
		'menu_slug'   => 'pdg-js',
        'parent_slug' => 'pdg-options'
    ] );

    acf_add_options_sub_page( [
        'page_title'  => 'Optimisation',
        'menu_title'  => 'Optimisation',
		'menu_slug'   => 'pdg-optimisation',
        'parent_slug' => 'pdg-options'
    ] );

    if ( $has_yoast ) {
        acf_add_options_sub_page( [
            'page_title'  => 'YOAST Breadcrumbs',
            'menu_title'  => 'YOAST Breadcrumbs',
            'menu_slug'   => 'pdg-breadcrumbs',
            'parent_slug' => 'pdg-options'
        ] );
    }

} );

/**
 * Include option page fields.
 */
// Theme options.
include PDG_INC . '/options/pdgc-general.php';
include PDG_INC . '/options/pdgc-soc.php';

// PandaGo options.
include PDG_INC . '/options/pdg-general.php';
include PDG_INC . '/options/pdg-js.php';
include PDG_INC . '/options/pdg-optimisation.php';
include PDG_INC . '/options/pdg-breadcrumbs.php';