<?php if ( ! defined( 'ABSPATH' ) ) exit;

class PDGC_Block
{

    public $block;    // ACF block array.
    public $post_id;  // Post ID block is saved to.
    public $template; // Template path.
    public $path;     // Template path.
    public $url;      // Template URL.
    public $args;     // Template arguments.

    public function __construct( $block, $post_id ) {

        $this->block    = $block;
        $this->post_id  = $post_id;
        $this->template = str_replace( 'index.php', 'template', $this->block['render_template'] );
        $this->path     = str_replace( 'index.php', '', $this->block['render_template'] );
        $this->url      = get_stylesheet_directory_uri() . '/' . $this->path;

    }

    public function get_heading_tag() {

        return get_field( 'heading_tag' ) ?: 'h2';

    }

    public function the_block_title( $text, $classes = '', $atts = [] ) {

        if ( $text ) {
            $tag = $this->get_heading_tag();

            $attributes = '';
    
            if ( $atts ) {
                foreach ( $atts as $name => $value ) {
                    $attributes .= "{$name}=\"{$value}\"";
                }
            }
    
            echo "<{$tag} class=\"{$classes}\" {$attributes}>{$text}</{$tag}>";
        }

    }

    public function the_title( $classes = '', $atts = [], $text = '' ) {

        if ( ! $text ) {
            $text = $this->args['content']['title'];
        }

        if ( ! $text ) {
            return;
        }

        $tag = apply_filters( 'pdgc_block_title_tag', $this->get_heading_tag(), $this->block['id'] );

        $attributes = '';

        if ( $atts ) {
            foreach ( $atts as $name => $value ) {
                $attributes .= "{$name}=\"{$value}\"";
            }
        }

        echo "<{$tag} class=\"{$classes}\" {$attributes}>{$text}</{$tag}>";

    }

    public function the_block_anchor() {

        if ( isset( $this->block['anchor'] ) && $this->block['anchor'] ) {
            echo "id='{$this->block['anchor']}'";
        }

    }

    public function the_block_class( $slug = false, $echo = true ) {

        $classes = [];

        if ( $slug ) {
            $classes[] = "{$slug}--{$this->block['id']}";
        }

        if ( isset( $this->block['className'] ) && $this->block['className'] ) {
            $classes[] = $this->block['className'];
        }

        $hide_on = get_field( 'hide_block_on' );

        if ( isset( $this->block['data']['hide_block_on'] ) && $this->block['data']['hide_block_on'] ) {
            $hide_on = $this->block['data']['hide_block_on'];
        }

        if ( $hide_on ) {
            $has_hide_sm = in_array( 'sm', $hide_on );
            $has_hide_md = in_array( 'md', $hide_on );
            $has_hide_lg = in_array( 'lg', $hide_on );

            if ( $has_hide_sm && ! $has_hide_md && ! $has_hide_lg ) {
                $classes[] = 'd-none';
                $classes[] = 'd-md-block';
            }

            if ( $has_hide_sm && $has_hide_md && ! $has_hide_lg ) {
                $classes[] = 'd-none';
                $classes[] = 'd-lg-block';
            }

            if ( $has_hide_sm && ! $has_hide_md && $has_hide_lg ) {
                $classes[] = 'd-none';
                $classes[] = 'd-md-block';
                $classes[] = 'd-lg-none';
            }

            if ( $has_hide_sm && $has_hide_md && $has_hide_lg ) {
                $classes[] = 'd-none';
            }

            if ( ! $has_hide_sm && $has_hide_md && ! $has_hide_lg ) {
                $classes[] = 'd-md-none';
                $classes[] = 'd-lg-block';
            }

            if ( ! $has_hide_sm && ! $has_hide_md && $has_hide_lg ) {
                $classes[] = 'd-lg-none';
            }

            if ( ! $has_hide_sm && $has_hide_md && $has_hide_lg ) {
                $classes[] = 'd-md-none';
            }
        }

        $classes = apply_filters( 'pdgc_block_class_' . $this->block['id'], $classes );

        if ( $classes ) {
            if ( $echo ) {
                echo implode( ' ', $classes );
            } else {
                return implode( ' ', $classes );
            }
        }

    }

    public function get_fields( $group, $is_grouped_by_key = false ) {

        foreach ( $this->args[$group] as $key => $default ) {
            $field_name = $key;

            if ( $is_grouped_by_key ) {
                $field_name = "{$group}_$key";
            }

            if ( get_field( $field_name ) || get_field( $field_name ) === '0' || get_field( $field_name ) === false ) {
                $this->args[$group][$key] = get_field( $field_name );
            } else {
                $this->args[$group][$key] = $default;
            }
        }

    }

    public function get_content() {

		foreach ( $this->args['content'] as $key => $default ) {
			$this->args['content'][$key] = get_field( $key ) ?: $default;
		}

    }

	public function get_items() {

		$this->args['items'] = get_field( 'items' );

	}

    public function get_settings() {

		foreach ( $this->args['settings'] as $key => $value ) {
			if ( get_field( $key ) || get_field( $key ) === '0' || get_field( $key ) === false ) {
				$this->args['settings'][$key] = get_field( $key );
			} else {
				$this->args['settings'][$key] = $value;
			}
		}

    }

    private function set_block_background() {

        $background = get_field( 'pdg_background_color' );

        if ( $background == 'none' ) {
            return;
        }

        add_filter( 'pdgc_block_class_' . $this->block['id'], function( $classes ) use ( $background ) {

            if ( apply_filters( 'pdg_block_background_additional_classes', true ) ) {
                $classes[] = 'full-width';
                $classes[] = 'relative';
            }

            $classes[] = "bgc-{$background}";

            return $classes;

        } );

    }

    public function the_block_container( $type = 'start', $classes = '' ) {

        if ( get_field( 'pdg_background_color' ) != 'none' ) {
            if ( $type == 'start' ) {
                echo '<div class="container ' . $classes . '">';
            } else {
                echo '</div>';
            }
        }

    }

    public function the_item( $args ) {

        get_template_part( $this->template, 'item', $args );

    }

    public function render() {

        if ( ( get_field( 'hide_block' ) && is_user_logged_in() && current_user_can( 'manage_options' ) ) || ! get_field( 'hide_block' ) ) {
            $this->set_block_background();

            get_template_part( $this->template, null, array_merge( $this->args, [
                'instance' => $this
            ] ) );
        }

    }

}