<?php if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Register custom block categories.
 */
add_filter( 'block_categories_all', function( $categories, $post ) {

    $categories[] = [
        'slug'  => 'custom',
        'title' => 'Custom'
	];

    return $categories;

}, 10, 2 );

add_filter( 'acf/pre_save_block', function( $attributes ) {

    if ( empty( $attributes['id'] ) ) {
        $attributes['id'] = substr( uniqid(), -6 );
    }

    return $attributes;

} );

/**
 * Add built-in blocks.
 */
add_action( 'acf/init', function() {

	PDG::add_block( 'Reusable Block', false );

} );

/**
 * Add Reusable Block post type.
 */
add_action( 'init', function() {

	register_post_type( 'reusable-block', array(
		'labels' => array(
			'name' => 'Reusable Blocks',
			'singular_name' => 'Reusable Block',
			'menu_name' => 'Reusable Blocks',
			'all_items' => 'Reusable Blocks',
			'edit_item' => 'Edit Reusable Block',
			'view_item' => 'View Reusable Block',
			'view_items' => 'View Reusable Blocks',
			'add_new_item' => 'Add New Reusable Block',
			'add_new' => 'Add New Reusable Block',
			'new_item' => 'New Reusable Block',
			'parent_item_colon' => 'Parent Reusable Block:',
			'search_items' => 'Search Reusable Blocks',
			'not_found' => 'No reusable blocks found',
			'not_found_in_trash' => 'No reusable blocks found in Trash',
			'archives' => 'Reusable Block Archives',
			'attributes' => 'Reusable Block Attributes',
			'insert_into_item' => 'Insert into reusable block',
			'uploaded_to_this_item' => 'Uploaded to this reusable block',
			'filter_items_list' => 'Filter reusable blocks list',
			'filter_by_date' => 'Filter reusable blocks by date',
			'items_list_navigation' => 'Reusable Blocks list navigation',
			'items_list' => 'Reusable Blocks list',
			'item_published' => 'Reusable Block published.',
			'item_published_privately' => 'Reusable Block published privately.',
			'item_reverted_to_draft' => 'Reusable Block reverted to draft.',
			'item_scheduled' => 'Reusable Block scheduled.',
			'item_updated' => 'Reusable Block updated.',
			'item_link' => 'Reusable Block Link',
			'item_link_description' => 'A link to a reusable block.',
		),
		'public' => false,
		'exclude_from_search' => false,
		'show_ui' => true,
		'show_in_menu' => 'themes.php',
		'show_in_admin_bar' => false,
		'show_in_rest' => true,
		'menu_icon' => 'dashicons-admin-post',
		'supports' => array(
			0 => 'title',
			1 => 'editor',
		),
		'rewrite' => false,
		'delete_with_user' => false,
	) );

} );

/**
 * Add fields to reusable block.
 */
add_action( 'acf/include_fields', function() {

	if ( ! function_exists( 'acf_add_local_field_group' ) ) {
		return;
	}

	acf_add_local_field_group( array(
		'key' => 'group_6880ddb41bede',
		'title' => 'Reusable Block',
		'fields' => array(
			array(
				'key' => 'field_6880ddb4c9a10',
				'label' => 'Content',
				'name' => '',
				'aria-label' => '',
				'type' => 'tab',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'placement' => 'top',
				'endpoint' => 0,
				'selected' => 0,
			),
			array(
				'key' => 'field_6880ddd7c9a11',
				'label' => 'Block',
				'name' => 'block',
				'aria-label' => '',
				'type' => 'post_object',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'post_type' => array(
					0 => 'reusable-block',
				),
				'post_status' => array(
					0 => 'publish',
				),
				'taxonomy' => '',
				'return_format' => 'object',
				'multiple' => 0,
				'allow_null' => 0,
				'allow_in_bindings' => 0,
				'bidirectional' => 0,
				'ui' => 1,
				'bidirectional_target' => array(
				),
			),
		),
		'location' => array(
			array(
				array(
					'param' => 'block',
					'operator' => '==',
					'value' => 'acf/reusable-block',
				),
			),
		),
		'menu_order' => 0,
		'position' => 'normal',
		'style' => 'default',
		'label_placement' => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen' => '',
		'active' => true,
		'description' => '',
		'show_in_rest' => 0,
	) );

} );

/**
 * Add fields to all blocks.
 */
add_action( 'acf/include_fields', function() {

	if ( ! function_exists( 'acf_add_local_field_group' ) ) {
		return;
	}

	// Add "Hide Block" field to all ACF blocks.
	acf_add_local_field_group( array(
		'key' => 'group_6470b46b3fccd',
		'title' => 'Block',
		'fields' => array(
			array(
				'key' => 'field_655330f182cf8',
				'label' => 'Heading Tag',
				'name' => 'heading_tag',
				'aria-label' => '',
				'type' => 'select',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'wpml_cf_preferences' => 1,
				'choices' => array(
					'h1' => 'h1',
					'h2' => 'h2',
					'h3' => 'h3',
				),
				'default_value' => 'h2',
				'return_format' => 'value',
				'multiple' => 0,
				'allow_null' => 0,
				'ui' => 0,
				'ajax' => 0,
				'placeholder' => '',
			),
			array(
				'key' => 'field_6470b46b07a28',
				'label' => 'Hide Block',
				'name' => 'hide_block',
				'aria-label' => '',
				'type' => 'true_false',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'wpml_cf_preferences' => 1,
				'message' => '',
				'default_value' => 0,
				'ui' => 0,
				'ui_on_text' => '',
				'ui_off_text' => '',
			),
			array(
				'key' => 'field_661f918aa7254',
				'label' => 'Hide Block On',
				'name' => 'hide_block_on',
				'aria-label' => '',
				'type' => 'checkbox',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'wpml_cf_preferences' => 1,
				'choices' => array(
					'lg' => 'lg',
					'md' => 'md',
					'sm' => 'sm',
				),
				'default_value' => array(
				),
				'return_format' => 'value',
				'allow_custom' => 0,
				'layout' => 'horizontal',
				'toggle' => 0,
				'save_custom' => 0,
				'custom_choice_button_text' => 'Add new choice',
			),
		),
		'location' => array(
			array(
				array(
					'param' => 'block',
					'operator' => '==',
					'value' => 'all',
				),
			),
		),
		'menu_order' => 0,
		'position' => 'normal',
		'style' => 'default',
		'label_placement' => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen' => '',
		'active' => true,
		'description' => '',
		'show_in_rest' => 0,
		'acfml_field_group_mode' => 'advanced',
	) );

	// Add "Minimize" tab.
	acf_add_local_field_group( array(
		'key' => 'group_65683ce75b9b7',
		'title' => 'Block Minimize',
		'fields' => array(
			array(
				'key' => 'field_65683ce84189b',
				'label' => 'Minimize',
				'name' => '',
				'aria-label' => '',
				'type' => 'tab',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'wpml_cf_preferences' => 0,
				'placement' => 'top',
				'endpoint' => 0,
			),
		),
		'location' => array(
			array(
				array(
					'param' => 'block',
					'operator' => '==',
					'value' => 'all',
				),
			),
		),
		'menu_order' => 9999,
		'position' => 'normal',
		'style' => 'default',
		'label_placement' => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen' => '',
		'active' => true,
		'description' => '',
		'show_in_rest' => 0,
		'acfml_field_group_mode' => 'advanced',
	) );

	// Add "Background Color" field to blocks.
	acf_add_local_field_group( array(
		'key' => 'group_674ed2e9201f9',
		'title' => 'Block Background',
		'fields' => array(
			array(
				'key' => 'pdg_background_color',
				'label' => 'Background Color',
				'name' => 'pdg_background_color',
				'aria-label' => '',
				'type' => 'select',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'wpml_cf_preferences' => 1,
				'choices' => apply_filters( 'pdg_block_background_color_choices', [
					'none'  => 'None',
					'light' => 'Light',
					'white' => 'White',
				] ),
				'default_value' => apply_filters( 'pdg_block_background_color_default', 'none' ),
				'return_format' => 'value',
				'multiple' => 0,
				'allow_null' => 0,
				'allow_in_bindings' => 0,
				'ui' => 0,
				'ajax' => 0,
				'placeholder' => '',
			),
		),
		'location' => array(
			apply_filters( 'pdg_block_background_color_locations', [
				[
					'param' => 'block',
					'operator' => '==',
					'value' => 'all',
			]
			] ),
		),
		'menu_order' => 0,
		'position' => 'normal',
		'style' => 'default',
		'label_placement' => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen' => '',
		'active' => true,
		'description' => '',
		'show_in_rest' => 0,
		'acfml_field_group_mode' => 'translation',
	) );

} );