<?php if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Check ACF Availability
 *
 * @package PandaGo3
 * @subpackage Core
 * @since 3.0.0
 * @version 3.0.0
 *
 * This theme relies on ACF plugin. Functions in this file checks if ACF plugin
 * is installed and active, otherwise an error message is displayed.
 *
 * @author sem.lv
 * @link   https://sem.lv/
 * @license GPL-2.0+
 */

add_action( 'admin_notices', function() {

    if ( ! function_exists( 'get_field' ) ) {
        echo '<div class="notice notice-error"><p>PandaGo3 requires "Advanced Custom Fields" plugin to work! <a href="/wp-admin/plugins.php?page=tgmpa-install-plugins">Install now.</a></p></div>';
    }

} );

if ( ! is_admin() && $GLOBALS['pagenow'] != 'wp-login.php' && $GLOBALS['pagenow'] != 'wp-logout.php' && ! function_exists( 'get_field' ) ) {
    die( 'PandaGo3 requires "Advanced Custom Fields" plugin to work!' );
}