<?php if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Theme defines.
 */
define( 'PDG_PATH',       get_template_directory() );
define( 'PDG_INC',        PDG_PATH . '/includes' );
define( 'PDG_URL',        get_template_directory_uri() );
define( 'PDG_VER',        wp_get_theme()->parent()->get( 'Version' ) );
define( 'PDG_PLUGINS',    'http://developers.sem.lv/pandago3/plugins' );
define( 'PDG_UPDATE_URL', 'http://developers.sem.lv/pandago3/update/update.json' );

/**
 * Check for ACF plugin.
 */
include PDG_INC . '/acf-check.php';

/**
 * Plugin downloader/activator.
 */
include PDG_INC . '/vendor/TGM_Plugin_Activation.php';
include PDG_INC . '/plugins.php';

/**
 * Allow plugins to be installed without ACF.
 */
if ( is_admin() && ! function_exists( 'get_field' ) && ! in_array( $GLOBALS['pagenow'], array( 'wp-login.php' ) ) ) {
    return;
}

/**
 * Core features.
 */
include PDG_INC . '/core.php';

/**
 * Cleanup WP junk.
 */
include PDG_INC . '/cleanup.php';

/**
 * Base theme assets.
 */
include PDG_INC . '/assets.php';

/**
 * ACF blocks.
 */
include PDG_INC . '/blocks.php';

/**
 * Theme functions.
 */
include PDG_INC . '/class-pdg.php';

/**
 * Options pages.
 */
include PDG_INC . '/options.php';

/**
 * Theme updates.
 */
include PDG_INC . '/update.php';