class PDGC
{

    constructor() {

        this.cacheSelectors();
        this.listeners();
        this.setScrolledClass();

    }

    /**
     * Cache frequently used selectors.
     */
    cacheSelectors() {

        this.$window = $( window );
        this.$body   = $( 'body' );

    }

    /**
     * Add event listerners.
     */
    listeners() {

        this.$window.on( 'scroll', () => this.setScrolledClass() );

        $( '.js-burger' ).on( 'click', () => this.toggleHandheldMenu() );

    }

    /**
     * Toggle "is-scrolled" class on body element.
     */
    setScrolledClass() {

        this.$body.toggleClass( 'is-scrolled', this.$window.scrollTop() > 24 );

    }

    /**
     * Toggle "nav-open" class on body element.
     */
    toggleHandheldMenu() {

        this.$body.toggleClass( 'nav-open' );

    }

}

$( document ).ready( () => new PDGC() );