<?php if ( ! defined( 'ABSPATH' ) ) exit;
/**
 * This file contains code related to WordPress Gutenberg editor.
 * You can define font sizes, available colors, etc. here.
 * 
 * @package pandago3-child
 */

/**
 * Restrict some Gutenberg blocks.
 * Add/remove as needed.
 */
add_filter( 'allowed_block_types_all', function( $allowed_block_types ) {

    // Allow basic blocks.
    $allowed_block_types = [
        // Text
		'core/paragraph',
		'core/heading',
		'core/list',
        'core/list-item',
        'core/freeform',
        'core/table',
        
        // Media
        'core/image',
        'core/audio',
        'core/video',
        'core/file',

        // Design
        'core/separator',
        'core/spacer',

        // Widgets
        'core/shortcode',
        'core/html',

        // Embeds
        'core/embed'
    ];

    // Allow custom ACF blocks.
    // If you need to see all block types you can PDG::dump( $all_block_types ); exit; after the next line.
    $all_block_types = array_keys( WP_Block_Type_Registry::get_instance()->get_all_registered() );

    if ( $all_block_types ) {
        foreach ( $all_block_types as $block_type ) {
            if ( strpos( $block_type, 'acf/' ) === 0 ) {
                $allowed_block_types[] = $block_type;
            }
        }
    }

    return $allowed_block_types;

} );